function varargout = viewcorr(varargin)
% VIEWCORR MATLAB code for viewcorr.fig
%      VIEWCORR, by itself, creates a new VIEWCORR or raises the existing
%      singleton*.
%
%      H = VIEWCORR returns the handle to a new VIEWCORR or the handle to
%      the existing singleton*.
%
%      VIEWCORR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIEWCORR.M with the given input arguments.
%
%      VIEWCORR('Property','Value',...) creates a new VIEWCORR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before viewcorr_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to viewcorr_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help viewcorr

% Last Modified by GUIDE v2.5 24-Aug-2021 06:20:42

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @viewcorr_OpeningFcn, ...
                   'gui_OutputFcn',  @viewcorr_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before viewcorr is made visible.
function viewcorr_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to viewcorr (see VARARGIN)

    movegui(hObject, 'center'); 
% Choose default command line output for viewcorr
handles.output = hObject;
set(handles.currentPath,'string',pwd);
set(handles.sublist,'string','');
set(handles.compid,'string','');
set(hObject,'name','ViewCorrelation');
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes viewcorr wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = viewcorr_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function currentPath_Callback(hObject, eventdata, handles)


function currentPath_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function workdirbtn_Callback(hObject, eventdata, handles)

theDir=get(handles.currentPath,'string');
dirname=uigetdir(theDir,'Please select the result path: ');
 
set(handles.sublist,'String','','value',1);
flag=0;
if ~isequal(dirname,0)
    set(handles.currentPath,'String',dirname);
    outputList=dir(dirname);
    outputList(1:2)=[]; 
    
    
    for i=1:length(outputList)
        if isequal(outputList(i).name,'ComponentsOutput')
            
            sublist=dir(fullfile(dirname,filesep,outputList(i).name));
            sublist(1:2)=[];
            flag=1;  
            break;
        end


    end

    if flag==1
        
        for i=1:length(sublist)
            index=get(handles.sublist,'value');
            set(handles.sublist,'String',strvcat(get(handles.sublist,'string'),sublist(i).name),'Value',max(index,1));
%        
        end
        tDmatlist='';
        sub_name=get(handles.sublist,'string');
        sub_id=get(handles.sublist,'value');
        filename=strcat(dirname,filesep,'ComponentsOutput',filesep,sub_name(sub_id,:),filesep,'IC');
        filelist=dir(filename);
        filelist(1:2)=[];
        for i=1:length(filelist)
            if endsWith(filelist(i).name,'nii')
                tDmatlist=strvcat(tDmatlist,filelist(i).name);
            end
        end
        
        if ~isempty(tDmatlist)
            labellist=[];
            for i=1:size(tDmatlist,1)
                [dd, FileName, extn] = fileparts(deblank(tDmatlist(i,:)));
%                 [dd, label_number] = icatb_parseExtn(extn);
                 k=strfind(FileName,'_');
                 label= FileName(k(end)+1:end);
                 labellist=[labellist,str2num(label)];
            end
            labellist=unique(labellist);
            list='';
            for i=1:length(labellist)
                list=strcat(list,num2str(labellist(i)),',');
            end
            list(end)='';
            set(handles.compid,'string',list);
        end
            
    else
        error('there is not exist output component');
        exit;
    end

else
%     set(handles.currentPath,'String',get(handles.currentPath,'String'));
    
end



function sublist_Callback(hObject, eventdata, handles)


function sublist_CreateFcn(hObject, eventdata, handles)

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function ok_Callback(hObject, eventdata, handles)

% sublist=get(handles.sublist,'string');
currentPath=get(handles.currentPath,'string');
subindex=get(handles.sublist,'value');
sublist=get(handles.sublist,'string');
subname=sublist(subindex,:);
outputfile=strcat(currentPath,filesep,'ComponentsOutput',filesep,subname,filesep,'TC');

compid=get(handles.compid,'string');
 %split the string
     remain=strtrim(compid);
     num=0;
     ICNID=[];
     while remain
        [token,remain]=strtok(remain,',');
        ICNID(num+1,:)=str2num(token);
        num=num+1;
     end
     corrmatrix=[];
     
     for i=1:length(ICNID)
         TCmatfile=strcat(outputfile,filesep,subname,'_TC_',num2str(ICNID(i)),'.mat');
         load(TCmatfile);
         corrmatrix(:,i)=a;
     end
%      diag(corrmatrix)
    connecMatrix=corr(corrmatrix);
    connecMatrix=connecMatrix+diag(nan+zeros(1,length(connecMatrix)));
     figure,imagesc(connecMatrix);
     colorbar;
%      colorbar('ticks',)
%      caxis([]);
     set(gca,'fontsize',12);
     xlabel('Component ID');
     ylabel('Component ID');
     title(strcat('Functional Network Connectivity Of Subject',32,subname));
     set(gcf,'name',strcat('Functional Network Connectivity',32,subname));
     set(gca,'titlefontweight','bold');
%      h=gca;
%      th=rotateticklabel(h, 45);
     axis square;
%      set(gca,'xtick',ICNID,'ytick',ICNID);
     set(gca,'xtick',[1:length(ICNID)],'xticklabel',ICNID,'ytick',[1:length(ICNID)],'yticklabel',ICNID);
%      set(gca, 'XTickLabelRotation', 45);
   
function compid_Callback(hObject, eventdata, handles)


function compid_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
